/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
// Optimised raymarch by TheEmu

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// If the display is jerky then reduce the value for MAX_ITERATIONS. This will
// reduce the calcultions needed for each pixel,  but  at  the  expense of the
// quality of generated image.

#define MAX_ITERATIONS 64

/////////////////////////////////////////////////////////////////////////////////

#define PI 3.1415926535897932384626433832795

float noise(vec3 p) //Thx to Las^Mercury
{
   vec3 i = floor(p);
   vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
   vec3 f = cos((p-i)*PI)*(-.5)+.5;
   a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
   a.xy = mix(a.xz, a.yw, f.y);
   return mix(a.x, a.y, f.z);
}

float sphere(vec3 p, vec4 spr)
{
   return length(spr.xyz-p) - spr.w;
}

float flame(vec3 p)
{
   float d = sphere(p*vec3(1.,.5,1.), vec4(.0,-1.,.0,1.));
   return d + (noise(p+vec3(.0,iGlobalTime*2.,.0)) + noise(p*3.)*.5)*.25*(p.y) ;
}

vec4 raymarch(vec3 org, vec3 dir)
{
   float d = 0.0, f = 0.0, glow = 0.0, eps = 0.02;
   vec3  p = org;

   for(int i=0; i<MAX_ITERATIONS; i++)
   {
      d = min(100.-length(p),abs(f)) + eps;
      p += d * dir;
      f = flame(p);
      if( (d > eps) && ( (glow > 0.0) || (f <0.0) ) )
        { glow = float(i);
        }
   }
   return vec4(p,glow/float(MAX_ITERATIONS));
}

void main()
{
   vec2 v = -1.0 + 2.0 * gl_FragCoord.xy / iResolution.xy;
   v.x *= iResolution.x/iResolution.y;

   vec3 org = vec3(0., -2., 4.);
   vec3 dir = normalize(vec3(v.x*1.6, -v.y, -1.5));

   vec4 p = raymarch(org, dir);
   float glow = p.w;

   vec4 col = mix(vec4(1.,.5,.1,1.), vec4(0.1,.5,1.,1.), p.y*.02+.4);

   gl_FragColor = mix(vec4(0.), col, pow(glow*2.,4.));
   //gl_FragColor = mix(vec4(1.), mix(vec4(1.,.5,.1,1.),vec4(0.1,.5,1.,1.),p.y*.02+.4), pow(glow*2.,4.));

}

